<?php
namespace lib;

abstract class db
{
	private static $handler;
	
	public static function init($driver, $host, $username, $password, $database)
	{
		try
		{
			self::$handler = new \PDO($driver.':host='.$host.';dbname='.$database, $username, $password);
			self::$handler->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
		} catch(\Exception $e)
		{
			throw new \Pawn\Exception('Configuration', "Couldn't connect to database. Please check the information in cache/db.php.", false, false);
		}
		
		$result = self::execute('SELECT * FROM '.PREFIX.'config')->fetchAll();
		$config = array();
		
		foreach($result as $row)
		{
			$config[$row['key']] = $row['value'];
		}
		
		return $config;
	}
	
	public static function setHandler($handler)
	{
		self::$handler = $handler;
	}
	
	public static function prepare($query)
	{
		return self::$handler->prepare($query);
	}
	
	public static function execute($query, $manual=false)
	{
		try
		{
			$sth = self::$handler->prepare($query);
			$sth->execute();
		} catch(\Exception $e)
		{
			if($manual)
			{
				throw new \Pawn\Exception('Database', "The query couldn't be executed because your database user lacks permission or some other mistake occurred. Please try running the following query on your database manually.", false, false, 0, $sth->queryString);
			}
		}
		
		return $sth;
	}
	
	public static function query($query, $data=array())
	{
		try
		{
			$sth = self::$handler->prepare($query);
			$sth->execute((array) $data);
		} catch(\Exception $e)
		{
			$error = $sth->errorInfo();
			$debug = debug_backtrace();
			
			if(PAWN_ENV == 'development')
			{
				ob_end_clean();
				
				print_r($debug);
				
				exit;
			}
			
			throw new \Pawn\Exception('Database', $error[2], $debug[0]['file'], $debug[0]['line'], 0, $sth->queryString);
		}
		
		return $sth;
	}
	
	public static function last_id()
	{
		return self::$handler->lastInsertId();
	}
	
	public static function quote($string)
	{
		return self::$handler->quote($string);
	}
}